#!/bin/ruby

require 'optparse'
require 'ostruct'

class OptparseClass
	#
	#	Return structure describing the options.
	#
	def self.parse(args)
		# Set default options
		options = OpenStruct.new
		options.verbose = false
		options.srcFile = ""

		opts = OptionParser.new do |opts|
			opts.banner = "Usage cverifysignature.rb [options] filename"

			opts.separator ""
			opts.separator "Specific options:"
		
			# Boolean switches
			opts.on("-v", "--[no-]verbose", "Run verbosely") do |v|
				options.verbose = v
			end

			opts.separator ""
			opts.separator "Common options:"
		
			opts.on_tail("-h", "--help", "Show this message") do
				puts opts
				exit
			end
		end
		
		opts.parse!(args)
		# Handle file arguments
		if ARGV.count != 1 then
			puts opts
			exit
		else
			options.filename = ARGV[0]
		end
		ARGV.each do |file|
			if not File.file? file then
				puts "Cannot open file: #{file}"
				exit
			end
		end

		options
	end	# parse()
end	# class OptparseClass

options = OptparseClass.parse(ARGV)
if File.file? options.outFile and not options.new then
	puts "Signature operation could not be completed since #{options.filename} does not exits."
	exit
end

#
# Do the work
#

hash1 = `ruby chash.rb #{options.filename}`
hash2 = `ruby cdecryptsignature.rb #{options.filename}`

if hash1 == hash2 then
	puts "Signature valid"
else
	puts "Signature invalid"
end

