#!/bin/ruby

require 'optparse'
require 'ostruct'
require 'tempfile'

class OptparseClass
	#
	#	Return structure describing the options.
	#
	def self.parse(args)
		# Set default options
		options = OpenStruct.new
		options.verbose = false
		options.srcFile = ""

		opts = OptionParser.new do |opts|
			opts.banner = "Usage cunwrap.rb [options] filename"

			opts.separator ""
			opts.separator "Specific options:"
		
			# Boolean switches
			opts.on("-v", "--[no-]verbose", "Run verbosely") do |v|
				options.verbose = v
			end

			opts.separator ""
			opts.separator "Common options:"
		
			opts.on_tail("-h", "--help", "Show this message") do
				puts opts
				exit
			end
		end
		
		opts.parse!(args)
		# Handle file arguments
		if ARGV.count != 1 then
			puts opts
			exit
		else
			options.srcFile = ARGV[0]
			options.filename = "#{ARGV[0]}.ds"
		end
		ARGV.each do |file|
			if not File.file? file then
				puts "Cannot open file: #{file}"
				exit
			end
		end

		options
	end	# parse()
end	# class OptparseClass

options = OptparseClass.parse(ARGV)
if File.file? options.outFile and not options.new then
	puts "Signature operation could not be completed since #{options.filename} does not exits."
	exit
end

#
# Do the work
#

f = open(options.filename, 'r').readlines
diff = f[(f.size - f.reverse.index("-----BEGIN DIFF-----\n"))..(f.size - f.reverse.index("-----END DIFF-----\n") - 2)]

if diff.size == 0 then
	puts "No diff found. Signatures are not wrapped."
	exit
end

diffFile = Tempfile.new('diff')
diffFile << diff
diffFile.flush
system "patch #{options.srcFile} #{diffFile.path.gsub(' ', '\ ')}"

newsize = f[0..(f.size - f.reverse.index("-----BEGIN DIFF-----\n") - 1)].map{|l|l.size}.reduce(:+)
open(options.filename, 'w').truncate(newsize)
