#!/bin/ruby

require 'optparse'
require 'ostruct'
require 'tempfile'
require 'base64'

class OptparseClass
	#
	#	Return structure describing the options.
	#
	def self.parse(args)
		# Set default options
		options = OpenStruct.new
		options.verbose = false
		options.srcFile = ""

		opts = OptionParser.new do |opts|
			opts.banner = "Usage cdecryptsignature.rb [options] filename"

			opts.separator ""
			opts.separator "Specific options:"
		
			# Boolean switches
			opts.on("-v", "--[no-]verbose", "Run verbosely") do |v|
				options.verbose = v
			end

			opts.separator ""
			opts.separator "Common options:"
		
			opts.on_tail("-h", "--help", "Show this message") do
				puts opts
				exit
			end
		end
		
		opts.parse!(args)
		# Handle file arguments
		if ARGV.count != 1 then
			puts opts
			exit
		else
			options.filename = "#{ARGV[0]}.ds"
		end
		ARGV.each do |file|
			if not File.file? file then
				puts "Cannot open file: #{file}"
				exit
			end
		end

		options
	end	# parse()
end	# class OptparseClass

options = OptparseClass.parse(ARGV)
if File.file? options.outFile and not options.new then
	puts "Signature operation could not be completed since #{options.filename} does not exits."
	exit
end

#
# Do the work
#

f = open(options.filename, 'r').readlines
signature = f[(f.size - f.reverse.index("-----BEGIN SIGNATURE-----\n")-1)..(f.size - f.reverse.index("-----END SIGNATURE-----\n"))-1].join
key = f[(f.size - f.reverse.index("-----BEGIN PUBLIC KEY-----\n")-0)..(f.size - f.reverse.index("-----END PUBLIC KEY-----\n"))-2].join


class Tempfile
	def escaped_path
		path.gsub(' ', '\ ')
	end
end

sigFile = Tempfile.new('sig')
sigFile << signature
sigFile.flush
keyFile = Tempfile.new('key')
keyFile << key
keyFile.flush

verify = `openssl rsautl -in #{sigFile.escaped_path) -verify -inkey #{keyFile.escaped_path} -pubin`
puts verify